--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'SQL_ASCII';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

--
-- Name: ferber_params_fbrp_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('ferber_params_fbrp_id_seq', 373, true);


--
-- Data for Name: ferber_params; Type: TABLE DATA; Schema: public; Owner: postgres
--

SET LOCAL SESSION AUTHORIZATION 'syncro';
ALTER TABLE ferber_params DISABLE TRIGGER ALL;

INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (101, 10, 'BRENNSCH SCHWENKZAPF', 'Gesamtlänge', 'l', 136, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (102, 20, 'BRENNSCH SCHWENKZAPF', 'Breite ( Ø )', 'd', 85, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (103, 30, 'BRENNSCH SCHWENKZAPF', 'Stegmaß', 's', 86, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (104, 40, 'BRENNSCH SCHWENKZAPF', 'BohrungsØ', 'b', 46, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (105, 50, 'BRENNSCH SCHWENKZAPF', 'Vorschub aus Tabelle', 'f', 400, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (96, 10, 'BRENNSCHNEIDEN ECKIG', '1. Seitenlänge', 'a', 405, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (98, 20, 'BRENNSCHNEIDEN ECKIG', '2. Seitenlänge', 'b', 405, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (99, 30, 'BRENNSCHNEIDEN ECKIG', 'BohrungsØ', 'd', 110, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (100, 40, 'BRENNSCHNEIDEN ECKIG', 'Vorschub aus Tabelle', 'f', 250, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (56, 10, 'BO+GEW', 'Kernloch Durchmesser', 'kern', 22, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (57, 20, 'BO+GEW', 'Gewinde Durchmesser', 'gew', 24, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (58, 30, 'BO+GEW', 'Kernlochtiefe', 'kernt', 66, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (278, 10, 'SW-KOLBENSTANGE', 'kleinster Ø', 'k', 60, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (59, 40, 'BO+GEW', 'Gewindetiefe', 'gewt', 53, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (60, 50, 'BO+GEW', 'Schnittgeschwindigkeit Kernlock', 'kernv', 120, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (62, 70, 'BO+GEW', 'Vorschub Kernloch pro Umdrehung', 'kernf', 0.2, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (66, 110, 'BO+GEW', 'Anzahl Bohrungen', 'a', 16, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (143, 10, 'GEWICHT ECKIG', 'Länge', 'l', 560, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (144, 20, 'GEWICHT ECKIG', 'Breite', 'b', 560, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (145, 30, 'GEWICHT ECKIG', 'Länge oder Blechstärke', 't', 90, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (8, 30, 'DREHEN PLAN KONSTAND', 'Schnittgeschwindigkeit', 'v', 180, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (6, 10, 'DREHEN PLAN KONSTAND', 'Größter Ø', 'd', 570, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (7, 20, 'DREHEN PLAN KONSTAND', 'Kleinster Ø', 'k', 380, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (9, 40, 'DREHEN PLAN KONSTAND', 'Vorschub pro Umdrehung', 'f', 0.35, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (10, 50, 'DREHEN PLAN KONSTAND', 'Zustellungen', 't', 1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (28, 10, 'DR LÄNGS+SCHL KONST', 'Größter Ø', 'd', 240, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (29, 20, 'DR LÄNGS+SCHL KONST', 'Kleinster Ø', 'k', 146, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (149, 20, 'SAEGEN', 'Vorschub in mm/min', 't', 33, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (279, 20, 'SW-KOLBENSTANGE', 'größter Ø', 'g', 115, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (280, 30, 'SW-KOLBENSTANGE', 'Öffnungswinkel kpl.', 'w', 60, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (291, 10, 'SW WIG-WURZEL', 'Start Ø', 'd', 148, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (33, 60, 'DR LÄNGS+SCHL KONST', 'Drehlänge', 'l', 95, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (273, 80, 'FR KREISTASCHE', 'Zustellungestiefe je Schnitt', 'az', 5, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (80, 75, 'DR LÄNGS+SCHL KONST', 'Schlicht Ø', 'g', 140, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (16, 10, 'DREHEN LANG KONST', 'Größter Ø', 'd', 125, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (30, 30, 'DR LÄNGS+SCHL KONST', 'Schnittgeschwindigkeit schruppen', 'v', 180, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (31, 40, 'DR LÄNGS+SCHL KONST', 'Vorschub pro Umdrehung schruppen', 'f', 0.40000001, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (17, 20, 'DREHEN LANG KONST', 'Kleinster Ø', 'k', 80, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (18, 30, 'DREHEN LANG KONST', 'Schnittgeschwindigkeit', 'v', 170, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (34, 70, 'DR LÄNGS+SCHL KONST', 'Schnittgeschwindigkeit schlichten', 's', 200, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (35, 80, 'DR LÄNGS+SCHL KONST', 'Vorschub pro Umdrehung schlichten', 'm', 0.1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (36, 90, 'DR LÄNGS+SCHL KONST', 'Zustellungen schlichten', 'r', 1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (37, 10, 'DR LÄNGS+SCHL', 'Gößter Ø', 'd', 200, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (38, 20, 'DR LÄNGS+SCHL', 'Kleinster Ø', 'k', 100, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (39, 30, 'DR LÄNGS+SCHL', 'Schnittgeschwindigkeit schruppen', 'v', 180, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (40, 40, 'DR LÄNGS+SCHL', 'Vorschub pro Umdrehung schruppen', 'f', 0.40000001, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (72, 50, 'FRAESEN GEWINDE', 'Schnittgeschwindigkeit', 'v', 140, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (42, 60, 'DR LÄNGS+SCHL', 'Drehlänge', 'l', 150, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (43, 70, 'DR LÄNGS+SCHL', 'Schnittgeschwindigkeit schlichten', 's', 200, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (44, 80, 'DR LÄNGS+SCHL', 'Vorschub pro Umdrehung schlichten', 'm', 0.1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (45, 90, 'DR LÄNGS+SCHL', 'Zustellungen schlichten', 'r', 1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (77, 70, 'FRAESEN GEWINDE', 'Schnitte je Gewinde', 'u', 2, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (41, 50, 'DR LÄNGS+SCHL', 'Zustellungen schruppen', 't', 10, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (19, 40, 'DREHEN LANG KONST', 'Vorschub pro Umdrehung', 'f', 0.3, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (21, 60, 'DREHEN LANG KONST', 'Drehlänge', 'l', 60, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (78, 80, 'FRAESEN GEWINDE', 'Umläufe je Gewinde', 'h', 22, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (50, 50, 'FR PLAN', 'Länge Frässpur ohne An - u. Überfahrweg', 'l', 360, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (362, 10, 'BRENNSCHNEID STRECKE', 'kpl. zu schneidende Strecke in mm', 'l', 1000, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (363, 20, 'BRENNSCHNEID STRECKE', 'Vorschub aus Tabelle', 'f', 100, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (15, 50, 'BOHREN', 'Anzahl Bohrungen', 'z', 1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (22, 10, 'DREHEN LANG', 'Größter Ø', 'd', 125, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (137, 60, 'DREHEN GEWINDE', 'Bearbeitung CNC(lösen Schlossmutter)=1 ohne lösen Schlossmutter =2', 'z', 1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (54, 65, 'DR LÄNGS+SCHL', 'Ø schlichten', 'g', 200, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (24, 20, 'DREHEN LANG', 'Schnittgeschwindigkeit', 'v', 280, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (26, 40, 'DREHEN LANG', 'Anzahl der Zustellungen', 't', 1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (85, 50, 'SW-SWKZ-ROHR', 'tief Nahtvorbereitung', 't', 10, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (27, 50, 'DREHEN LANG', 'Drehlänge', 'l', 850, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (194, 60, 'HONEN', 'Anzahl Honsteine', 'z', 4, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (195, 70, 'HONEN', 'Vorschubsgeschwindigkeit Hubbewegung', 'f', 4000, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (239, 150, 'BOHREN VENTIL AS5', 'Schnittgeschwindigkeit Gewinde', 'gewv', 3, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (166, 160, 'BOHREN AS3', 'Anzahl Bohrungen', 'a', 1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (240, 160, 'BOHREN VENTIL AS5', 'Vorschub pro Umdrehung Oelkanal', 'oelf', 0.15000001, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (25, 30, 'DREHEN LANG', 'Vorschub pro Umdrehung', 'f', 0.18, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (200, 50, 'SCHLEIFEN PLAN', 'Zustellungsbreite je Hub', 'b', 30, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (11, 10, 'BOHREN', 'Bohrer Ø', 'd', 125, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (197, 20, 'SCHLEIFEN PLAN', 'Breite', 'bu', 100, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (12, 20, 'BOHREN', 'Bohrtiefe', 't', 850, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (199, 40, 'SCHLEIFEN PLAN', 'Abtrag je Zustellung', 'a', 0.0099999998, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (13, 30, 'BOHREN', 'Schnittgeschwindigkeit', 'v', 280, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (201, 60, 'SCHLEIFEN PLAN', 'Vorschubsgeschwindigkeit Hubbewegung', 'vf', 3000, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (79, 90, 'FRAESEN GEWINDE', 'Anzahl Gewinde', 'a', 12, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (67, 10, 'FRAESEN GEWINDE', 'Gewinde Ø', 'g', 42, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (74, 60, 'FRAESEN GEWINDE', 'Vorschub je Zahn', 'z', 0.064999998, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (69, 20, 'FRAESEN GEWINDE', 'Fäser Ø', 'd', 27.700001, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (75, 30, 'FRAESEN GEWINDE', 'Zähnezahl', 'e', 3, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (70, 40, 'FRAESEN GEWINDE', 'Steigung', 'p', 4.5, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (14, 40, 'BOHREN', 'Vorschub pro Umdrehung', 'f', 0.15, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (308, 10, 'SCHLEIFEN RUND', 'Schleif-Ø', 'D', 40, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (196, 10, 'SCHLEIFEN PLAN', 'Länge', 'la', 750, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (81, 10, 'SW-SWKZ-ROHR', 'mittlerer SchweißØ', 'm', 283, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (82, 20, 'SW-SWKZ-ROHR', 'Paßungs Ø', 'd', 268, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (84, 40, 'SW-SWKZ-ROHR', 'Öffnungswinkel in Grad', 'w', 45, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (86, 60, 'SW-SWKZ-ROHR', 'Winkel Außennaht in Grad', 'a', 30, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (88, 80, 'SW-SWKZ-ROHR', 'Dichte Schweißdraht', 'l', 7.8499999, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (90, 100, 'SW-SWKZ-ROHR', 'Anzahl Schweißnähte', 'z', 2, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (314, 30, 'SCHLEIFEN RUND', 'Zustellung je Schleifgang', 't', 0.05, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (89, 90, 'SW-SWKZ-ROHR', 'Sicherheit für Handhabung in %', 'o', 20, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (202, 70, 'SCHLEIFEN PLAN', 'Anzahl Schnitte fürs Ausfeuern', 'f', 5, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (91, 30, 'SW-SWKZ-ROHR', 'Radius der Schweißnahtvorbereitung', 'r', 8, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (309, 20, 'SCHLEIFEN RUND', 'Aufmaß (Schleifzugabe)', 'A', 0.1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (198, 30, 'SCHLEIFEN PLAN', 'Aufmaß', 't', 0.15000001, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (161, 110, 'BOHREN AS3', 'Gewindesteigung in mm', 'p', 1.34, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (241, 170, 'BOHREN VENTIL AS5', 'Vorschub pro Umdrehung Senkung', 'senkf', 0.15000001, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (132, 10, 'DREHEN GEWINDE', 'GewindeØ', 'd', 125, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (61, 60, 'BO+GEW', 'Schnittgeschwindigkeit Gewinde', 'gewv', 3, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (242, 180, 'BOHREN VENTIL AS5', 'Vorschub pro Umdrehung Stufenbohrer', 'stbf', 0.15000001, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (243, 190, 'BOHREN VENTIL AS5', 'Vorschub pro Umdrehung Stufenreibahle', 'strf', 0.07, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (95, 30, 'BRENNSCHNEIDEN RUND', 'Vorschub aus Tabelle', 'f', 400, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (244, 200, 'BOHREN VENTIL AS5', 'Gewindesteigung in mm', 'p', 1.5, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (63, 80, 'BO+GEW', 'Gewindesteigung in mm', 'p', 3, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (64, 90, 'BO+GEW', 'Werkzeugwechselzeit in sek.', 'werkz', 15, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (65, 100, 'BO+GEW', 'Gewindebohrer Einfettzeit in sek.', 'fettz', 15, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (366, 30, 'GEWICHT SECHSKANT', 'Dichte Material', 'd', 7.85, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (364, 10, 'GEWICHT SECHSKANT', 'SW - Sechskant', 'a', 46, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (365, 20, 'GEWICHT SECHSKANT', 'Länge / Zuschnitt in mm', 't', 55, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (344, 90, 'SW-FLANSCH-ROHR', 'Anzahl Schweißnähte', 'A', 1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (343, 80, 'SW-FLANSCH-ROHR', 'Handhabungssicherheit in %', 'sich', 0, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (341, 60, 'SW-FLANSCH-ROHR', 'Schweißparameter aus Liste', 'para', 0, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (20, 50, 'DREHEN LANG KONST', 'Anzahl der Zustellungen', 't', 5, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (2, 20, 'DREHEN PLAN', 'Kleinster Ø', 'k', 0, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (106, 10, 'FR KONTUR ECKIG AU', '1. Seitenlänge', 'a', 160, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (107, 20, 'FR KONTUR ECKIG AU', '2. Seitenlänge', 'b', 210, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (108, 30, 'FR KONTUR ECKIG AU', 'FräserØ', 'd', 63, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (110, 50, 'FR KONTUR ECKIG AU', 'Schnittgeschwindigkeit m/min', 'v', 150, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (111, 60, 'FR KONTUR ECKIG AU', 'Vorschub pro Schneide mm/U', 'f', 0.1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (109, 40, 'FR KONTUR ECKIG AU', 'Schneidenanzahl', 'z', 4, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (315, 70, 'FR KONTUR RUND IN', 'Anzahl', 'i', 1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (113, 10, 'FR KONTUR ECKIG IN', '1. Seitenlänge', 'a', 160, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (114, 20, 'FR KONTUR ECKIG IN', '2. Seitenlänge', 'b', 210, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (115, 30, 'FR KONTUR ECKIG IN', 'FräserØ', 'd', 63, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (116, 40, 'FR KONTUR ECKIG IN', 'Schneidenanzahl', 'z', 4, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (117, 50, 'FR KONTUR ECKIG IN', 'Schnittgeschwindigkeit m/min', 'v', 150, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (118, 60, 'FR KONTUR ECKIG IN', 'Vorschub pro Schneide mm/U', 'f', 0.1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (119, 70, 'FR KONTUR ECKIG IN', 'Zustellungen', 't', 2, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (112, 70, 'FR KONTUR ECKIG AU', 'Anzahl der Zustellungen', 't', 2, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (3, 30, 'DREHEN PLAN', 'Schnittgeschwindigkeit', 'v', 200, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (122, 30, 'FR KONTUR RUND AU', 'Schneidenanzahl', 'z', 4, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (123, 40, 'FR KONTUR RUND AU', 'Schnittgeschwindigkeit m/min', 'v', 150, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (124, 50, 'FR KONTUR RUND AU', 'vorschub pro Schneide', 'f', 0.1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (125, 60, 'FR KONTUR RUND AU', 'Zustellungen', 't', 2, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (121, 20, 'FR KONTUR RUND AU', 'FräserØ', 'd', 63, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (126, 10, 'FR KONTUR RUND IN', 'Ø', 'a', 130, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (127, 20, 'FR KONTUR RUND IN', 'FräserØ', 'd', 63, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (128, 30, 'FR KONTUR RUND IN', 'Schneidenanzahl', 'z', 4, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (4, 40, 'DREHEN PLAN', 'Vorschub je Umdrehung', 'f', 0.35, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (131, 60, 'FR KONTUR RUND IN', 'Zustellungen', 't', 2, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (129, 40, 'FR KONTUR RUND IN', 'Schnittgeschwindigkeit m/min', 'v', 150, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (130, 50, 'FR KONTUR RUND IN', 'Vorschub pro Schneide mm/U', 'f', 0.1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (5, 50, 'DREHEN PLAN', 'Zustellungen', 't', 1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (87, 70, 'SW-SWKZ-ROHR', 'Abschmelzleistung kg/min', 'i', 0.033300001, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (133, 20, 'DREHEN GEWINDE', 'Steigung', 'p', 1.5, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (134, 30, 'DREHEN GEWINDE', 'Schnittgeschwindigkeit', 'v', 140, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (157, 70, 'BOHREN AS3', 'Schnittgeschwindigkeit Kernloch', 'kernv', 22, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (158, 80, 'BOHREN AS3', 'Schnittgeschwindigkeit Gewinde', 'gewv', 3, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (159, 90, 'BOHREN AS3', 'Schnittgeschwindigkeit Senkung', 'senkv', 15, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (160, 100, 'BOHREN AS3', 'Vorschub Kernloch pro Umdrehung', 'kernf', 0.1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (162, 120, 'BOHREN AS3', 'Vorschub Senkung pro Umdrehung', 'senkf', 0.1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (163, 130, 'BOHREN AS3', 'Verweilzeit Anspiegeln der Dichtfläche in sek.', 'senkz', 3, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (164, 140, 'BOHREN AS3', 'Werkzeugwechselzeit in sek.', 'werkz', 15, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (165, 150, 'BOHREN AS3', 'Gewindebohrer Einfettzeit in sek.', 'fettz', 15, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (168, 20, 'BOHREN AS4', 'Kernloch Durchmesser', 'kern', 15, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (169, 40, 'BOHREN AS4', 'Senkung Durchmesser', 'senk', 28, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (170, 30, 'BOHREN AS4', 'Gewinde Durchmesser', 'gew', 17, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (203, 10, 'SW-ZYLROHR-MAG-UP', 'SchweißØ aussen', 'aus', 305, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (173, 70, 'BOHREN AS4', 'Gewindetiefe', 'gewt', 18, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (174, 80, 'BOHREN AS4', 'Senkungstiefe', 'senkt', 1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (204, 20, 'SW-ZYLROHR-MAG-UP', 'GrundØ', 'grund', 236, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (176, 140, 'BOHREN AS4', 'Vorschub Kernloch pro Umdrehung', 'kernf', 0.1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (188, 200, 'BOHREN AS4', 'Anzahl Bohrungen', 'a', 1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (178, 100, 'BOHREN AS4', 'Schnittgeschwindigkeit Kernloch', 'kernv', 22, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (179, 110, 'BOHREN AS4', 'Schnittgeschwindigkeit Gewinde', 'gewv', 3, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (180, 120, 'BOHREN AS4', 'Schnittgeschwindigkeit Senkung', 'senkv', 15, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (181, 150, 'BOHREN AS4', 'Gewindesteigung in mm', 'p', 1.34, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (184, 160, 'BOHREN AS4', 'Vorschub Senkung pro Umdrehung', 'senkf', 0.1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (185, 170, 'BOHREN AS4', 'Verweilzeit Anspiegeln der Dichtfläche in senk.', 'senkz', 3, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (186, 180, 'BOHREN AS4', 'Werkzeugwechselzeit in sek.', 'werkz', 15, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (187, 190, 'BOHREN AS4', 'Gewindebohrer Einfettzeit in sek.', 'fettz', 15, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (135, 40, 'DREHEN GEWINDE', 'Gewindelänge', 'l', 35, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (167, 10, 'BOHREN AS4', 'Oelkanal Durchmesser', 'oel', 8, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (177, 90, 'BOHREN AS4', 'Schnittgeschwindigkeit Oelkanal', 'oelv', 22, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (175, 130, 'BOHREN AS4', 'Vorschub Oelkanal pro Umdrehung', 'oelf', 0.07, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (171, 50, 'BOHREN AS4', 'Oelkanaltiefe', 'oelt', 100, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (172, 60, 'BOHREN AS4', 'Kernlochtiefe', 'kernt', 24, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (205, 30, 'SW-ZYLROHR-MAG-UP', 'Grundradius', 'radius', 4, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (136, 50, 'DREHEN GEWINDE', 'Anzahl Schnitte', 't', 7, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (148, 10, 'SAEGEN', 'Schnittlänge', 'l', 165, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (1, 10, 'DREHEN PLAN', 'Größter Ø', 'D', 165, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (32, 50, 'DR LÄNGS+SCHL KONST', 'Zustellungen schruppen', 't', 9, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (213, 10, 'FR KONTUR STRECKE', 'Verfahrstrecke in mm (kpl. mit An- u. Überfahrweg)', 't', 314, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (214, 20, 'FR KONTUR STRECKE', 'FräserØ', 'd', 16, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (215, 30, 'FR KONTUR STRECKE', 'Schneidenzahl', 'z', 4, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (218, 60, 'FR KONTUR STRECKE', 'Anzahl Zustellungen', 'a', 4, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (216, 40, 'FR KONTUR STRECKE', 'Schnittgeschwindigkeit', 'v', 65, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (206, 40, 'SW-ZYLROHR-MAG-UP', 'Öffnungswinkel in Grad', 'grad', 30, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (207, 50, 'SW-ZYLROHR-MAG-UP', 'Überhöhung', 'ueber', 2, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (209, 70, 'SW-ZYLROHR-MAG-UP', 'Materialdichte', 'dichte', 7.8499999, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (211, 90, 'SW-ZYLROHR-MAG-UP', 'Anzahl Schweißnähte', 'zahl', 2, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (208, 60, 'SW-ZYLROHR-MAG-UP', 'Zwischenmaß', 'zwisch', 0, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (225, 20, 'BOHREN VENTIL AS5', 'Senker Durchmesser', 'senk', 50, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (217, 50, 'FR KONTUR STRECKE', 'Vorschub pro Schneide', 'fz', 0.05, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (212, 100, 'SW-ZYLROHR-MAG-UP', 'Sicherheit in %', 'sich', 0, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (224, 10, 'BOHREN VENTIL AS5', 'Oelkanal Durchmesser', 'oel', 18, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (226, 30, 'BOHREN VENTIL AS5', 'Stufenbohrer Durchmesser', 'stb', 27.6, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (227, 40, 'BOHREN VENTIL AS5', 'Stufenreibahle Durchmesser', 'str', 28, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (228, 50, 'BOHREN VENTIL AS5', 'Gewinde Durchmesser', 'gew', 27, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (229, 60, 'BOHREN VENTIL AS5', 'Oelkanaltiefe', 'oelt', 110, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (230, 70, 'BOHREN VENTIL AS5', 'Senkungstiefe', 'senkt', 45, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (231, 80, 'BOHREN VENTIL AS5', 'Stufenbohrertiefe', 'stbt', 52, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (232, 90, 'BOHREN VENTIL AS5', 'Stufenreibahletiefe (Bearbeitungslänge)', 'strt', 9, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (233, 100, 'BOHREN VENTIL AS5', 'Gewindetiefe', 'gewt', 21, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (234, 110, 'BOHREN VENTIL AS5', 'Schnittgeschwindigkeit Oelkanal', 'oelv', 22, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (235, 120, 'BOHREN VENTIL AS5', 'Schnittgeschwindigkeit Senkung', 'senkv', 22, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (236, 130, 'BOHREN VENTIL AS5', 'Schnittgeschwindigkeit Stufenbohrer', 'stbv', 22, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (237, 140, 'BOHREN VENTIL AS5', 'Schnittgeschwindigkeit Stufenreibahle', 'strv', 10, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (248, 240, 'BOHREN VENTIL AS5', 'Anzahl der Bohrungen', 'a', 1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (246, 220, 'BOHREN VENTIL AS5', 'Werkzeugwechselzeit in sek.', 'werkz', 15, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (245, 210, 'BOHREN VENTIL AS5', 'Verweilzeit Anspiegeln der Dichtfläche in sek.', 'senkz', 3, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (247, 230, 'BOHREN VENTIL AS5', 'Gewindebohrer Einfettzeit in sek.', 'fettz', 5, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (249, 50, 'BOHREN VENTIL AS4', 'Oelkanaltiefe', 'oelt', 100, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (219, 10, 'BOHREN VENTIL AS4', 'Oelkanal Durchmesser', 'oel', 10, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (220, 20, 'BOHREN VENTIL AS4', 'Stufenbohrer Durchmesser', 'stb', 32, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (221, 30, 'BOHREN VENTIL AS4', 'Stufenreibahle Durchmesser', 'str', 15, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (222, 40, 'BOHREN VENTIL AS4', 'Gewinde Durchmesser', 'gew', 14, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (251, 60, 'BOHREN VENTIL AS4', 'Stufenbohrertiefe', 'stbt', 68, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (252, 70, 'BOHREN VENTIL AS4', 'Stufenreibahlentiefe', 'strt', 9, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (253, 80, 'BOHREN VENTIL AS4', 'Gewindetiefe', 'gewt', 18, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (254, 90, 'BOHREN VENTIL AS4', 'Schnittgeschwindigkeit Oelkanal', 'oelv', 22, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (255, 100, 'BOHREN VENTIL AS4', 'Schnittgeschwindigkeit Stufenbohrer', 'stbv', 22, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (256, 110, 'BOHREN VENTIL AS4', 'Schnittgeschwindigkeit Stufebreibahle', 'strv', 10, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (258, 130, 'BOHREN VENTIL AS4', 'Vorschub Oelkanal pro Umdrehung', 'oelf', 0.1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (259, 140, 'BOHREN VENTIL AS4', 'Vorschub Stufenbohrer pro Umdrehung', 'stbf', 0.1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (260, 150, 'BOHREN VENTIL AS4', 'Vorschub Stufenreibahle pro Umdrehung', 'strf', 0.050000001, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (261, 160, 'BOHREN VENTIL AS4', 'Gewindesteigung in mm', 'p', 1.5, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (262, 170, 'BOHREN VENTIL AS4', 'Verweilzeit Anspiegeln der Dichtfläche in sek.', 'senkz', 3, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (263, 180, 'BOHREN VENTIL AS4', 'Werkzeugwechselzeit in sek.', 'werkz', 15, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (264, 190, 'BOHREN VENTIL AS4', 'Gewindebohrer Einfettzeit in sek.', 'fettz', 5, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (265, 200, 'BOHREN VENTIL AS4', 'Anzahl Bohrungen', 'a', 1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (257, 120, 'BOHREN VENTIL AS4', 'Schnittgeschwindigkeit Gewindebohrer', 'gewv', 3, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (271, 70, 'FR KREISTASCHE', 'Vorschub zum Fräsen pro Zahn', 'ff', 0.079999998, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (269, 50, 'FR KREISTASCHE', 'Schnittgeschwindigkeit', 'v', 25, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (268, 40, 'FR KREISTASCHE', 'Schneidenanzahl Fräser', 'z', 4, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (266, 10, 'FR KREISTASCHE', 'Durchmesser Kreistasche', 'dk', 60, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (267, 30, 'FR KREISTASCHE', 'Fräserdurchmesser', 'd', 20, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (275, 10, 'SW-STRECKE', 'Länge der Schweißstrecke', 'l', 500, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (276, 20, 'SW-STRECKE', 'mögliche Strecke in mm pro Minute aus Tabelle', 'v', 178, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (277, 30, 'SW-STRECKE', 'Sicherheit in %', 's', 10, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (274, 90, 'FR KREISTASCHE', 'Anzahl Kreistaschen', 'ak', 1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (272, 20, 'FR KREISTASCHE', 'Tiefe der Kreistasche', 't', 10, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (270, 60, 'FR KREISTASCHE', 'Vorschub zum Einstechen', 'ft', 0.05, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (147, 50, 'GEWICHT ECKIG', 'Dichte', 'd', 7.85, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (92, 10, 'BRENNSCHNEIDEN RUND', 'AußenØ', 'd', 340, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (93, 20, 'BRENNSCHNEIDEN RUND', 'BohrungsØ', 'b', 150, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (51, 60, 'FR PLAN', 'Anzahl Frässpuren', 'i', 2, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (146, 40, 'GEWICHT ECKIG', 'Aufmaß für Brennfuge', 'f', 6, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (52, 70, 'FR PLAN', 'Zustellungen', 't', 34, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (305, 70, 'BOHREN + SENKEN', 'Vorschub pro Umdrehung beim Bohren', 'f', 0.15, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (189, 10, 'HONEN', 'Hondurchmesser', 'd', 180, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (190, 20, 'HONEN', 'Honlänge', 'l', 1350, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (297, 10, 'HANDARBEIT', 'Zeit für Handarbeit oder Merkmal in min', 't', 0.5, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (191, 30, 'HONEN', 'Aufmaß', 'a', 0.3, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (298, 20, 'HANDARBEIT', 'Stückzahl oder Merkmale', 'z', 5, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (192, 40, 'HONEN', 'Abtrag je Zustellung', 'q', 0.02, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (285, 10, 'SW-STRECKE RUND', 'Ø zum Aufschweißen', 'd', 140, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (120, 10, 'FR KONTUR RUND AU', 'Ø', 'a', 16, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (282, 40, 'SW-KOLBENSTANGE', 'Abschmelzleistung kg/min', 'p', 0.033, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (283, 50, 'SW-KOLBENSTANGE', 'Anzahl Schweißnähte', 'y', 2, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (288, 30, 'SW-STRECKE RUND', 'Aufschweißlänge je Runde', 'i', 5, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (284, 60, 'SW-KOLBENSTANGE', 'Sicherheit für Handhabung in %', 'x', 20, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (286, 20, 'SW-STRECKE RUND', 'Länge der Aufschweißung', 'l', 100, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (299, 10, 'BOHREN + SENKEN', 'Bohrer Ø', 'd', 24, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (300, 20, 'BOHREN + SENKEN', 'Senker Ø', 's', 42, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (290, 50, 'SW-STRECKE RUND', 'Anzahl der Lagen', 'h', 2, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (301, 30, 'BOHREN + SENKEN', 'Bohrtiefe', 't', 77, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (302, 40, 'BOHREN + SENKEN', 'Senktiefe', 'i', 3.5, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (303, 50, 'BOHREN + SENKEN', 'Schnittgeschwindigkeit fürs Bohren', 'v', 25, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (289, 40, 'SW-STRECKE RUND', 'mögliche Strecke in mm pro Minute aus Tabelle', 't', 1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (307, 90, 'BOHREN + SENKEN', 'Anzahl der Bohrungen', 'z', 1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (138, 10, 'GEWICHT RUND', 'AussenØ', 'a', 100, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (151, 10, 'BOHREN AS3', 'Kernloch Durchmesser', 'kern', 30, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (294, 60, 'SW WIG-WURZEL', 'Anzahl der Schweißnähte', 'a', 2, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (152, 20, 'BOHREN AS3', 'Gewinde Durchmesser', 'gew', 33, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (153, 30, 'BOHREN AS3', 'Senkung Durchmesser', 'senk', 41, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (304, 60, 'BOHREN + SENKEN', 'Schnittgeschwindigkeit fürs Senken', 'w', 25, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (295, 40, 'SW WIG-WURZEL', 'mögliche Strecke in mm pro Minute aus Tabelle', 'm', 100, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (306, 80, 'BOHREN + SENKEN', 'Vorschub pro Umdrehung beim Senken', 'g', 0.1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (292, 20, 'SW WIG-WURZEL', 'Lagen', 'L', 6, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (293, 30, 'SW WIG-WURZEL', 'Faktor für Lagen aus Tabelle', 'F', 3.5, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (140, 20, 'GEWICHT RUND', 'Länge oder Blechstärke', 't', 50, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (142, 30, 'GEWICHT RUND', 'Dichte', 'd', 7.85, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (296, 50, 'SW WIG-WURZEL', 'Sicherheit für Handhabung in %', 's', 10, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (154, 40, 'BOHREN AS3', 'Kernlochtiefe', 'kernt', 40, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (329, 30, 'SW-BODEN', 'Öffungswinkel Schweißnaht', 'o', 30, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (155, 50, 'BOHREN AS3', 'Gewindetiefe', 'gewt', 40, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (310, 40, 'SCHLEIFEN RUND', 'Schleiflänge mit Überlauf und Anlauf', 'L', 150, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (330, 40, 'SW-BODEN', 'Winkel von Überschweißung', 'w', 20, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (312, 60, 'SCHLEIFEN RUND', 'Vorschub pro Umdrehung in mm', 'f', 10, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (311, 50, 'SCHLEIFEN RUND', 'Drehzahl pro Minute', 'n', 30, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (156, 60, 'BOHREN AS3', 'Senkungstiefe', 'senkt', 2.5, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (193, 50, 'HONEN', 'Honsteinbreite', 'b', 10, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (46, 10, 'FR PLAN', 'Fräser Ø', 'd', 125, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (48, 30, 'FR PLAN', 'Schnittgeschwindigkeit', 'v', 140, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (47, 20, 'FR PLAN', 'Zähne- oder Schneidenanzahl Fräser', 'z', 10, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (333, 70, 'SW-BODEN', 'Dichte Schweißgut', 'dichte', 7.85, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (49, 40, 'FR PLAN', 'Vorschub pro Zahn oder Schneide', 'f', 0.2, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (325, 100, 'FR RECHTECKTASCHE', 'Anzahl der Taschen', 'ak', 1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (210, 80, 'SW-ZYLROHR-MAG-UP', 'Schweißparameter', 'para', 0, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (336, 10, 'SW-FLANSCH-ROHR', 'Aufsteck-Ø (Passung)', 'D', 250, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (337, 20, 'SW-FLANSCH-ROHR', 'Öffungswinkel Flansch', 'W', 25, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (338, 30, 'SW-FLANSCH-ROHR', 'Tiefe Schweißnahtvorbereitung Flansch', 'F', 16, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (339, 40, 'SW-FLANSCH-ROHR', 'Schweißnahtvorbereitungs-Ø Rohr', 'R', 235, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (340, 50, 'SW-FLANSCH-ROHR', 'Öffnungswinkel Rohr', 'O', 20, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (342, 70, 'SW-FLANSCH-ROHR', 'Dichte Schweißwerkstoff', 'dichte', 7.85, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (347, 20, 'FR PAßNUT', 'Nutlänge', 'ln', 25, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (345, 10, 'FR PAßNUT', 'Nutbreite', 'bn', 6, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (348, 30, 'FR PAßNUT', 'Nuttiefe', 'tn', 3.5, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (349, 40, 'FR PAßNUT', 'Fräserdurchmesser schruppen', 'dp', 5, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (351, 60, 'FR PAßNUT', 'Schnittgeschwindigkeit schruppen', 'vp', 25, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (353, 80, 'FR PAßNUT', 'Vorschub zum Fräsen pro Zahn', 'fp', 0.05, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (352, 70, 'FR PAßNUT', 'Vorschub zum Einstechen', 'ft', 0.03, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (354, 90, 'FR PAßNUT', 'Fräserdurchmesser schlichten', 'ds', 5, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (356, 110, 'FR PAßNUT', 'Schnittgeschwindigkeit schlichten', 'vs', 70, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (357, 120, 'FR PAßNUT', 'Vorschub pro Zahn schlichten', 'fs', 0.05, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (358, 130, 'FR PAßNUT', 'Schlichtdurchgänge', 'sz', 2, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (359, 85, 'FR PAßNUT', 'Zustellungstiefe je Schnitt beim schruppen', 'ap', 3.5, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (360, 140, 'FR PAßNUT', 'Anzahl Paßnuten', 'az', 1, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (361, 150, 'FR PAßNUT', 'Werkzeugwechselzeit in sec. (Maschinenabhängig)', 'tz', 15, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (350, 50, 'FR PAßNUT', 'Schneidenzahl Schruppfräser', 'zp', 2, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (355, 100, 'FR PAßNUT', 'Schneidenzahl Schlichtfräser', 'zs', 4, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (367, 10, 'SW-DHY-HY', 'Tiefe Schweißnaht (eine Seite)', 't', 10, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (370, 40, 'SW-DHY-HY', 'Länge der Schweißnaht', 'l', 100, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (371, 50, 'SW-DHY-HY', 'Dichte Schweißgut', 'dichte', 7.85, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (373, 70, 'SW-DHY-HY', 'Handhabungssichetheit in %', 'sich', 0, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (369, 30, 'SW-DHY-HY', 'Öffnungswinkel der Aussennaht in Grad', 'w', 20, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (372, 60, 'SW-DHY-HY', 'Abschmelztleistung aus Tabelle', 'para', 0, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (368, 20, 'SW-DHY-HY', 'Öffnungswinkel der Schweißnaht in Grad', 'o', 35, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (334, 80, 'SW-BODEN', 'Abschmelzleistung aus Tabelle', 'para', 0.0333, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (327, 10, 'SW-BODEN', 'Tiefe Schweißnaht', 't', 28, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (331, 50, 'SW-BODEN', 'Längevon Auge', 'l', 330, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (332, 60, 'SW-BODEN', 'Breite von Auge', 'b', 162, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (335, 90, 'SW-BODEN', 'Handhabungssicherheit in %', 'sich', 20, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (328, 20, 'SW-BODEN', 'Zwischenmaß', 'z', 5, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (317, 10, 'FR RECHTECKTASCHE', 'Länge der Tasche', 'lt', 120, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (318, 20, 'FR RECHTECKTASCHE', 'Breite der Tasche', 'bt', 30, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (326, 30, 'FR RECHTECKTASCHE', 'Tiefe der Tasche', 't', 5, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (319, 40, 'FR RECHTECKTASCHE', 'Fräserdurchmesser', 'd', 6, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (320, 50, 'FR RECHTECKTASCHE', 'Schneidenanzahl Fräser', 'z', 2, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (321, 60, 'FR RECHTECKTASCHE', 'Schnittgeschwindigkeit', 'v', 120, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (322, 70, 'FR RECHTECKTASCHE', 'Vorschub zum Einstechen', 'ft', 0.03, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (323, 80, 'FR RECHTECKTASCHE', 'Vorschub zum Fräsen pro Zahn', 'ff', 0.03, NULL);
INSERT INTO ferber_params (fbrp_id, fbrp_pos, fbrp_ferber, fbrp_descr, fbrp_name, fbrp_default, fbrp_formula) VALUES (324, 90, 'FR RECHTECKTASCHE', 'Zustellungstiefe je Schnitt', 'az', 0.3, NULL);


ALTER TABLE ferber_params ENABLE TRIGGER ALL;
RESET SESSION AUTHORIZATION;

-- keine leeren Statements am Ende vom Erstellen der DB erlaubt.
SELECT TRUE;
